/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.Types.MX2;

import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.IRegistratorConnector;
import com.esn.CGMServer.DEVICEModule.TDEVICEModule;
import com.esn.CGMServer.Utils.TMemoryInOutStreamAdapter;
import com.ftdichip.usb.FTDI;
import com.ftdichip.usb.FTDIUtility;
import com.ftdichip.usb.enumerated.FlowControl;
import com.ftdichip.usb.enumerated.LineDatabit;
import com.ftdichip.usb.enumerated.LineParity;
import com.ftdichip.usb.enumerated.LineStopbit;
import java.io.IOException;
import java.util.Collection;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import org.usb4java.javax.IrpQueue;

public class TMX2USBConnector
implements IRegistratorConnector {
    private static final String DeviceName = "ESNHOLTER";
    private FTDI Holter = null;
    private TReading Holter_Reading = null;

    public static FTDI GetHolterDevice() throws Exception {
        try {
            Collection<UsbDevice> Devices = FTDIUtility.findFTDIDevices();
            for (UsbDevice Device2 : Devices) {
                String DeviceName;
                try {
                    DeviceName = Device2.getProductString();
                    TDEVICEModule.log.info("Device.RegistratorModule.Registrator: Holter - " + DeviceName);
                }
                catch (Exception E) {
                    return FTDI.getInstance(Device2);
                }
                if (!DeviceName.startsWith(DeviceName)) continue;
                return FTDI.getInstance(Device2);
            }
        }
        catch (UsbClaimException UCE) {
            throw UCE;
        }
        catch (Exception E) {
            throw new IOException("! error: " + E.getMessage());
        }
        return null;
    }

    public static boolean CheckHolterDevice() throws Exception {
        FTDI Holter = TMX2USBConnector.GetHolterDevice();
        if (Holter != null) {
            Holter.close();
            return true;
        }
        return false;
    }

    @Override
    public void Connect() throws Exception {
        this.Disconnect();
        this.Holter = TMX2USBConnector.GetHolterDevice();
        if (this.Holter == null) {
            throw new IRegistratorConnector.RegistratorIsNotFoundException();
        }
        this.Holter.usbPipeRead.open();
        this.Holter.usbPipeWrite.open();
        this.Holter.configureSerialPort(460800, LineDatabit.BITS_8, LineStopbit.STOP_BIT_1, LineParity.NONE, FlowControl.DISABLE_FLOW_CTRL);
        this.Holter.SetLatencyTimer((short)2);
        this.Holter.Reset();
        this.Holter_Reading = new TReading();
    }

    @Override
    public void Disconnect() throws Exception {
        if (this.Holter != null) {
            this.Holter_Reading.Destroy();
            this.Holter.usbPipeRead.close();
            this.Holter.usbPipeWrite.close();
            this.Holter.close();
            this.Holter = null;
        }
    }

    @Override
    public boolean IsConnectable() {
        try {
            this.Connect();
            this.Disconnect();
            return true;
        }
        catch (Exception E) {
            return false;
        }
    }

    @Override
    public boolean IsConnected() {
        return this.Holter != null;
    }

    @Override
    public void Reset() throws Exception {
        this.Holter.Reset();
    }

    @Override
    public void Normalize() {
        this.Holter_Reading.InOutStreamAdapter.Normalize();
    }

    @Override
    public int Reading_Avaiable() throws Exception {
        return this.Holter_Reading.InOutStreamAdapter.Reading_Available();
    }

    @Override
    public int Writing_Avaiable() throws Exception {
        return -1;
    }

    @Override
    public void Reading_Purge() throws Exception {
        this.Holter_Reading.InOutStreamAdapter.Clean(Integer.MAX_VALUE, null);
    }

    @Override
    public void Writing_Purge() throws Exception {
    }

    @Override
    public int Read(byte[] BA, int Size, int Timeout) throws Exception {
        this.Holter_Reading.InOutStreamAdapter.Reading_Timeout = Timeout;
        return this.Holter_Reading.InOutStreamAdapter.Read(BA, 0, Size);
    }

    @Override
    public void Write(byte[] BA, int Size) throws Exception {
        int MaxPacketSize;
        int PacketSize = MaxPacketSize = this.Holter.usbPipeWrite.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize();
        byte[] Packet = new byte[PacketSize];
        for (int BA_Offset = 0; BA_Offset < Size; BA_Offset += PacketSize) {
            int Reminder = Size - BA_Offset;
            if (Reminder < MaxPacketSize) {
                PacketSize = Reminder;
                Packet = new byte[PacketSize];
            }
            System.arraycopy(BA, BA_Offset, Packet, 0, PacketSize);
            int WrittenCount = this.Holter.usbPipeWrite.syncSubmit(Packet);
            if (WrittenCount == PacketSize) continue;
            throw new IOException("wrong written bytes count");
        }
    }

    private class TReading
    implements Runnable {
        private final Thread thread;
        private boolean flCancelled = false;
        public final TMemoryInOutStreamAdapter InOutStreamAdapter = new TMemoryInOutStreamAdapter(true);

        public TReading() {
            this.thread = new Thread(this);
            this.thread.setPriority(10);
            this.thread.start();
        }

        public void Destroy() throws Exception {
            this.flCancelled = true;
            this.thread.join();
            this.InOutStreamAdapter.Destroy();
        }

        @Override
        public void run() {
            try {
                int Buffer_MaxSize = 0xA00000;
                short Packet_Size = ((TMX2USBConnector)TMX2USBConnector.this).Holter.usbPipeRead.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize();
                int Buffer_Size = 0xA00000 / Packet_Size * Packet_Size;
                byte[] Packet = new byte[Buffer_Size];
                IrpQueue Reader = ((TMX2USBConnector)TMX2USBConnector.this).Holter.usbPipeRead.GetPipe().queue;
                boolean Summary = false;
                long LT = System.currentTimeMillis();
                int Interval = 3000;
                while (!this.flCancelled) {
                    int ReadCount = Reader.read(Packet, 0, Packet.length);
                    if (ReadCount == 2) continue;
                    int Cnt = ReadCount / Packet_Size;
                    int Offset = 0;
                    for (int I = 0; I < Cnt; ++I) {
                        this.InOutStreamAdapter.OutStream().write(Packet, Offset + 2, Packet_Size - 2);
                        Offset += Packet_Size;
                    }
                    int Reminder = ReadCount % Packet_Size;
                    if (Reminder <= 2) continue;
                    this.InOutStreamAdapter.OutStream().write(Packet, Offset + 2, Reminder - 2);
                }
            }
            catch (Exception E) {
                TDEVICEModule.log.error("Device.RegistratorModule.Registrator.Reading.run(): error", E);
            }
        }
    }
}

