/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.Utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TRollingLogFile {
    public static final int Capacity = 1000;
    public static final int SavingThreshold = 1;
    public static final boolean flLogWarningMessages = true;
    public static final boolean flLogInfoMessages = true;
    private File LogFile;
    private String[] Items;
    private int Items_Position;
    private int Items_UnsavedCount = 0;

    public TRollingLogFile(String LogFileName) throws IOException {
        this.LogFile = new File(LogFileName);
        this.Items = new String[1000];
        this.Items_Position = 0;
        this.Items_UnsavedCount = 0;
        this.Load();
    }

    public void Destroy() throws IOException {
        if (this.Items_UnsavedCount > 0) {
            this.Save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Load() throws IOException {
        if (!this.LogFile.exists()) {
            return;
        }
        try (FileReader FR = new FileReader(this.LogFile);
             BufferedReader BR = new BufferedReader(FR);){
            String S;
            this.Items_Position = 0;
            while ((S = BR.readLine()) != null) {
                this.Items[this.Items_Position] = S;
                ++this.Items_Position;
                if (this.Items_Position < 1000) continue;
                this.Items_Position = 0;
            }
        }
        this.Items_UnsavedCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void Save() throws IOException {
        if (!this.LogFile.exists()) {
            String LogFolder = this.LogFile.getParent();
            File LF = new File(LogFolder);
            LF.mkdirs();
            this.LogFile.createNewFile();
        }
        try (FileWriter FW = new FileWriter(this.LogFile, false);
             BufferedWriter BW = new BufferedWriter(FW);){
            int Pos = this.Items_Position;
            for (int I = 0; I < 1000; ++I) {
                if (this.Items[Pos] != null) {
                    BW.append(this.Items[Pos]);
                    BW.newLine();
                }
                if (++Pos < 1000) continue;
                Pos = 0;
            }
        }
        this.Items_UnsavedCount = 0;
    }

    public String ToString() {
        StringBuilder SB = new StringBuilder();
        int Pos = this.Items_Position;
        for (int I = 0; I < 1000; ++I) {
            if (this.Items[Pos] != null) {
                SB.append(this.Items[Pos] + "\n");
            }
            if (++Pos < 1000) continue;
            Pos = 0;
        }
        return SB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] ToZippedByteArray() throws IOException {
        this.Save();
        if (!this.LogFile.exists()) {
            return null;
        }
        BufferedInputStream origin = null;
        try (ByteArrayOutputStream dest = new ByteArrayOutputStream();){
            try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));){
                int BUFFER = 2048;
                byte[] data = new byte[BUFFER];
                String FileName = this.LogFile.getName();
                try (FileInputStream fi = new FileInputStream(this.LogFile);){
                    origin = new BufferedInputStream(fi, BUFFER);
                    try {
                        int count;
                        ZipEntry entry = new ZipEntry(FileName);
                        out.putNextEntry(entry);
                        while ((count = origin.read(data, 0, BUFFER)) != -1) {
                            out.write(data, 0, count);
                        }
                    }
                    finally {
                        origin.close();
                    }
                }
            }
            byte[] byArray = dest.toByteArray();
            return byArray;
        }
    }

    private void AddItem(String S) {
        this.Items[this.Items_Position] = S;
        ++this.Items_Position;
        if (this.Items_Position >= 1000) {
            this.Items_Position = 0;
        }
        this.DoOnItemAdded();
    }

    private void DoOnItemAdded() {
        ++this.Items_UnsavedCount;
        if (this.Items_UnsavedCount > 1) {
            try {
                this.Save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void WriteInfo(String Source2, String Info) {
        String S = new SimpleDateFormat("dd/MM/yy HH:mm:ss").format(new Date()) + " INFO: " + Source2 + ", " + Info;
        this.AddItem(S);
    }

    public synchronized void WriteWarning(String Source2, String Warning) {
        String S = new SimpleDateFormat("dd/MM/yy HH:mm:ss").format(new Date()) + " WARNINIG: " + Source2 + ", " + Warning;
        this.AddItem(S);
    }

    public synchronized void WriteError(String Source2, String Error2) {
        String S = new SimpleDateFormat("dd/MM/yy HH:mm:ss").format(new Date()) + " ! ERROR: " + Source2 + ", " + Error2;
        this.AddItem(S);
    }

    public synchronized void WriteError(String Source2, String Error2, StackTraceElement[] StackTrace) {
        String S = new SimpleDateFormat("dd/MM/yy HH:mm:ss").format(new Date()) + " ! ERROR: " + Source2 + ", " + Error2;
        this.AddItem(S);
        if (StackTrace != null) {
            for (int I = 0; I < StackTrace.length; ++I) {
                StackTraceElement Element = StackTrace[I];
                S = "  " + Element.getClassName() + "." + Element.getMethodName() + " line: " + Integer.toString(Element.getLineNumber());
                this.AddItem(S);
            }
        }
    }
}

