/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.usb;

import com.ftdichip.usb.EEndpointDirection;
import com.ftdichip.usb.FTDIUtility;
import com.ftdichip.usb.enumerated.FlowControl;
import com.ftdichip.usb.enumerated.LineDatabit;
import com.ftdichip.usb.enumerated.LineParity;
import com.ftdichip.usb.enumerated.LineStopbit;
import java.util.Arrays;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbIrp;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbPipe;

public final class FTDI {
    private final UsbDevice usbDevice;
    private UsbInterface usbInterface;
    public UsbPipe usbPipeRead;
    public UsbPipe usbPipeWrite;

    public static FTDI getInstance(UsbDevice usbDevice) throws UsbException {
        FTDI ftdi = new FTDI(usbDevice);
        ftdi.configureSerialPort(115200, LineDatabit.BITS_8, LineStopbit.STOP_BIT_1, LineParity.NONE, FlowControl.DISABLE_FLOW_CTRL);
        FTDIUtility.setDTRRTS(usbDevice, false, true);
        return ftdi;
    }

    public FTDI(UsbDevice usbDevice) throws UsbException {
        this.usbDevice = usbDevice;
        UsbConfiguration configuration = usbDevice.getActiveUsbConfiguration();
        this.usbInterface = (UsbInterface)configuration.getUsbInterfaces().iterator().next();
        this.usbInterface.claim(usbInterface1 -> false);
        List Endpoints = this.usbInterface.getUsbEndpoints();
        int Cnt = Endpoints.size();
        for (int I = 0; I < Cnt; ++I) {
            UsbEndpoint EP = (UsbEndpoint)Endpoints.get(I);
            if (EEndpointDirection.HOST_TO_DEVICE.getByteCode() == EP.getDirection()) {
                this.usbPipeWrite = EP.getUsbPipe();
                continue;
            }
            this.usbPipeRead = EP.getUsbPipe();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FTDI.this.usbInterface.release();
                    Thread.sleep(250L);
                }
                catch (InterruptedException | UsbDisconnectedException | UsbException | UsbNotActiveException exception) {
                    // empty catch block
                }
            }
        });
    }

    public void close() {
        try {
            this.usbInterface.release();
            Thread.sleep(250L);
        }
        catch (InterruptedException | UsbDisconnectedException | UsbException | UsbNotActiveException exception) {
            // empty catch block
        }
    }

    public void Reset() throws UsbException, UsbException, UsbException {
        FTDIUtility.reset(this.usbDevice);
    }

    public void configureSerialPort(int requestedBaudRate, LineDatabit bits, LineStopbit stopbits, LineParity parity, FlowControl flowControl) throws UsbException {
        FTDIUtility.setBaudRate(this.usbDevice, requestedBaudRate);
        FTDIUtility.setLineProperty(this.usbDevice, bits, stopbits, parity);
        FTDIUtility.setFlowControl(this.usbDevice, flowControl);
    }

    public void SetLatencyTimer(short Value) throws UsbException, UsbException, UsbException {
        FTDIUtility.SetLatencyTimer(this.usbDevice, Value);
    }

    public void writeAsync(byte[] data) throws UsbException {
        if (!this.usbPipeWrite.isOpen()) {
            this.usbPipeWrite.open();
        }
        UsbIrp usbIrp = this.usbPipeWrite.createUsbIrp();
        usbIrp.setData(data);
        this.usbPipeWrite.asyncSubmit(usbIrp);
    }

    public int write(byte[] data) throws UsbException {
        if (!this.usbPipeWrite.isOpen()) {
            this.usbPipeWrite.open();
        }
        return this.usbPipeWrite.syncSubmit(data);
    }

    public byte[] read(int I) throws UsbException {
        byte[] usbFrame;
        int bytesRead;
        if (!this.usbPipeRead.isOpen()) {
            this.usbPipeRead.open();
        }
        return (bytesRead = this.usbPipeRead.syncSubmit(usbFrame = new byte[this.usbPipeRead.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize()])) == 2 ? new byte[]{} : Arrays.copyOfRange(usbFrame, 2, bytesRead);
    }

    public String toString() {
        return "FTDI " + this.usbDevice;
    }
}

