/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.Types.MX2;

import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.IRegistratorConnector;
import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.TRegistrator;
import com.esn.CGMServer.DEVICEModule.TDEVICEModule;
import com.esn.CGMServer.Utils.TDataConverter;
import com.esn.CGMServer.Utils.TDateTime;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeoutException;

public class TMX2
extends TRegistrator {
    public static final int DEVICETYPE_UNKNOWN = 0;
    public static final int DEVICETYPE_ESN0 = 1;
    public static final int DEVICETYPE_ESN0LITE = 2;
    public static final int FREQUENCY_UNKNOWN = 0;
    public static final int FREQUENCY_250 = 1;
    public static final int FREQUENCY_1000 = 2;
    public static final int CHANNELS_UNKNOWN = 0;
    public static final int CHANNELS_3 = 1;
    public static final int CHANNELS_8 = 2;
    public static final int LEADS_UNKNOWN = 0;
    public static final int LEADS_NONE = 1;
    public static final int LEADS_2 = 2;
    public static final int LEADS_3 = 3;
    public static final int LEADS_8 = 4;
    private static final int CommandReadTimeout = 3000;
    public int Version;
    public int DeviceManufacturer;
    public int DeviceHWVersion;
    public short DeviceType;
    public int DeviceSWVersion;
    public long DeviceID;
    public int DeviceHardwareStatus;
    public int DeviceStorageType;
    public int DevicePortSpeed;
    public int Frequency = 0;
    public int Channels = 0;
    public int Leads = 0;
    public boolean flReoChannel = false;
    public boolean flMovementChannel = false;
    public boolean flRecording = false;
    public boolean flIVR = false;
    public boolean flDisplayOn = false;
    public boolean flControllingFilter50Hz = false;
    public boolean flUnreadStorage = false;
    public boolean flDisplayLightOn = false;
    public boolean flBrokenLeadsControlIsSet = false;
    public boolean flLowPowerConsumption = false;
    public boolean flLeadsMode2 = false;
    public static final int Device_Storage_BlockSize = 2052;

    public TMX2(IRegistratorConnector pConnector) {
        super(pConnector);
    }

    @Override
    public void Device_Connect() throws Exception {
        super.Device_Connect();
        this.Device_Start();
        this.Device_Reset();
        Thread.sleep(100L);
        byte[] Request = new byte[]{0};
        byte[] Response = new byte[2];
        this.Connector.Write(Request, Request.length);
        this.Connector.Read(Response, Response.length, 3000);
        this.Version = TDataConverter.ConvertBEByteArrayToInt16(Response, 0);
    }

    @Override
    public void Device_Disconnect() throws Exception {
        if (this.Device_IsConnected()) {
            this.Device_Reset();
            super.Device_Disconnect();
        }
    }

    protected void Device_Request_Send(byte[] Request) throws Exception {
        this.Connector.Write(Request, Request.length);
        TDEVICEModule.log.trace("MX2.Request_Send(), request is sent, size: " + Request.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] Device_Response_Receive(int Timeout) throws Exception {
        byte[] ResponseBuffer = new byte[3];
        this.Connector.Read(ResponseBuffer, ResponseBuffer.length, Timeout);
        if (ResponseBuffer[0] != 42) {
            throw new IOException("\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
        int DataLength = ResponseBuffer[2] & 0xFF;
        if (DataLength > 200) {
            throw new Exception("\u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u042d\u041a\u0413, RC: " + Integer.toString(DataLength));
        }
        try {
            if (DataLength > 0) {
                byte[] ResponseDataBuffer = new byte[DataLength];
                this.Connector.Read(ResponseDataBuffer, ResponseDataBuffer.length, Timeout);
                byte[] Result2 = new byte[ResponseBuffer.length + ResponseDataBuffer.length];
                System.arraycopy(ResponseBuffer, 0, Result2, 0, ResponseBuffer.length);
                System.arraycopy(ResponseDataBuffer, 0, Result2, ResponseBuffer.length, ResponseDataBuffer.length);
                byte[] byArray = Result2;
                return byArray;
            }
            byte[] byArray = ResponseBuffer;
            return byArray;
        }
        finally {
            TDEVICEModule.log.trace("MX2.Response_Receive(), response is received, size: " + Integer.toString(DataLength));
        }
    }

    public void Device_Start() throws Exception {
        byte[] Request = new byte[8];
        for (int I = 0; I < Request.length; ++I) {
            Request[I] = 18;
        }
        this.Device_Request_Send(Request);
    }

    public void Device_Stop() throws Exception {
        byte[] Request = new byte[8];
        for (int I = 0; I < Request.length; ++I) {
            Request[I] = 17;
        }
        this.Device_Request_Send(Request);
    }

    public void Device_Remount() throws Exception {
        this.Device_Stop();
        this.Device_Start();
    }

    public void Device_Reset() throws Exception {
        int TryCount = 3;
        for (int I = 0; I < 3; ++I) {
            try {
                byte[] Request = new byte[]{42, 6, 0};
                this.Device_Request_Send(Request);
                this.Connector.Reading_Purge();
                int Count = 0x100000;
                int Timeout = 100;
                byte[] BA = new byte[1];
                for (int J = 0; J < 0x100000; ++J) {
                    this.Connector.Read(BA, BA.length, 100);
                }
                continue;
            }
            catch (IOException IOE) {
                if (IOE.getCause() instanceof TimeoutException) {
                    return;
                }
                throw IOE;
            }
            catch (TimeoutException TE) {
                return;
            }
        }
        throw new IOException("\u043d\u0435 \u0441\u043c\u043e\u0433 \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Update() throws Exception {
        int TryCount = 5;
        Exception _E = null;
        for (int I = 0; I < 5; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[]{42, 0, 0};
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0440\u0438\u0431\u043e\u0440\u0430");
                    }
                    if (Response[2] != 10) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0440\u0438\u0431\u043e\u0440\u0430");
                    }
                    this.DeviceManufacturer = TDataConverter.ConvertBEByteArrayToInt16(Response, 3) & 0xFFFF;
                    this.DeviceHWVersion = TDataConverter.ConvertBEByteArrayToInt16(Response, 5) & 0xFFFF;
                    this.DeviceType = (short)(this.DeviceHWVersion & 0xFF);
                    this.DeviceHWVersion = (this.DeviceHWVersion & 0xFF00) >>> 8;
                    this.DeviceSWVersion = TDataConverter.ConvertBEByteArrayToInt16(Response, 7) & 0xFFFF;
                    this.DeviceID = TDataConverter.ConvertBEByteArrayToInt32(Response, 9);
                    Thread.sleep(20L);
                    Request = new byte[]{42, 4, 0};
                    this.Device_Request_Send(Request);
                    Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0440\u0435\u0436\u0438\u043c\u0430 \u043f\u0440\u0438\u0431\u043e\u0440\u0430");
                    }
                    if (Response[2] != 4) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0440\u0435\u0436\u0438\u043c\u0430 \u043f\u0440\u0438\u0431\u043e\u0440\u0430");
                    }
                    this.Frequency = (Response[3] & 1) != 0 ? 2 : 1;
                    this.Channels = (Response[3] & 2) != 0 ? 2 : 1;
                    boolean bl = this.flReoChannel = (Response[3] & 4) != 0;
                    this.flLowPowerConsumption = (this.DeviceType == 1 && this.DeviceHWVersion >= 1 || this.DeviceType == 2 && this.DeviceHWVersion >= 2) && this.DeviceSWVersion >= 31 ? (Response[3] & 0x10) != 0 : false;
                    this.flMovementChannel = (Response[3] & 0x20) != 0;
                    boolean bl2 = this.flRecording = (Response[3] & 0x40) != 0;
                    this.flIVR = this.DeviceType == 1 || this.DeviceType == 2 && this.DeviceSWVersion >= 2 ? (Response[3] & 0x80) != 0 : false;
                    this.flDisplayOn = (Response[4] & 1) != 0;
                    this.flControllingFilter50Hz = (Response[4] & 2) == 0;
                    boolean bl3 = this.flUnreadStorage = (Response[4] & 4) == 0;
                    if ((Response[4] & 0x10) != 0) {
                        this.Leads = 3;
                    } else if ((Response[4] & 0x20) != 0) {
                        this.Leads = 4;
                    }
                    this.flLeadsMode2 = (Response[4] & 0x40) != 0;
                    boolean bl4 = this.flDisplayLightOn = (Response[5] & 1) != 0;
                    this.flBrokenLeadsControlIsSet = (this.DeviceType == 1 && this.DeviceHWVersion >= 1 || this.DeviceType == 2 && this.DeviceHWVersion >= 1) && this.DeviceSWVersion >= 31 ? (Response[5] & 4) != 0 : false;
                    this.DeviceHardwareStatus = (this.DeviceType == 1 && this.DeviceHWVersion >= 1 || this.DeviceType == 2 && this.DeviceHWVersion >= 1) && this.DeviceSWVersion >= 33 ? Response[6] : 0;
                    if (!this.flRecording) {
                        Request = new byte[]{42, 29, 0};
                        this.Device_Request_Send(Request);
                        Response = this.Device_Response_Receive(3000);
                        if (Response[1] != Request[1]) {
                            throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0438\u043f\u0430 \u043f\u0430\u043c\u044f\u0442\u0438");
                        }
                        if (Response[2] != 5) {
                            throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0438\u043f\u0430 \u043f\u0430\u043c\u044f\u0442\u0438");
                        }
                        this.DeviceStorageType = Response[4] & 0xFF;
                    } else {
                        this.DeviceStorageType = -1;
                    }
                    if (!this.flRecording) {
                        if (this.DeviceType == 1 || this.DeviceType == 2 && this.DeviceSWVersion >= 28) {
                            Request = new byte[]{42, 31, 1, -1};
                            this.Device_Request_Send(Request);
                            Response = this.Device_Response_Receive(3000);
                            if (Response[1] != Request[1]) {
                                throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e\u0440\u0442\u0430");
                            }
                            if (Response[2] != 1) {
                                throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e\u0440\u0442\u0430");
                            }
                            this.DevicePortSpeed = Response[3] & 0xFF;
                        } else {
                            this.DevicePortSpeed = 0;
                        }
                    } else {
                        this.DevicePortSpeed = -1;
                    }
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        if (_E != null) {
            throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Update(), " + _E.getLocalizedMessage(), _E);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_SetMode() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[11];
                    Request[0] = 42;
                    Request[1] = 3;
                    Request[2] = 8;
                    Request[3] = -1;
                    Request[4] = -1;
                    Request[5] = -1;
                    Request[6] = -1;
                    Request[7] = 0;
                    if (this.Frequency == 2) {
                        Request[7] = (byte)(Request[7] | 1);
                    }
                    if (this.Channels == 2) {
                        Request[7] = (byte)(Request[7] | 2);
                    }
                    if (this.flReoChannel) {
                        Request[7] = (byte)(Request[7] | 4);
                    }
                    if (this.flMovementChannel) {
                        Request[7] = (byte)(Request[7] | 0x20);
                    }
                    if (this.flRecording) {
                        Request[7] = (byte)(Request[7] | 0x40);
                    }
                    if ((this.DeviceType == 1 || this.DeviceType == 2 && this.DeviceSWVersion >= 2) && this.flIVR) {
                        Request[7] = (byte)(Request[7] | 0x80);
                    }
                    if (this.flLowPowerConsumption) {
                        Request[7] = (byte)(Request[7] | 0x10);
                        Request[7] = (byte)(Request[7] & 0xFFFFFFFB);
                        Request[7] = (byte)(Request[7] & 0xFFFFFFDF);
                    } else {
                        Request[7] = (byte)(Request[7] | 4);
                        Request[7] = (byte)(Request[7] | 0x20);
                    }
                    Request[8] = 0;
                    if (this.flDisplayOn) {
                        Request[8] = (byte)(Request[8] | 1);
                    }
                    if (this.flControllingFilter50Hz) {
                        Request[8] = (byte)(Request[8] | 2);
                    }
                    if (!this.flUnreadStorage) {
                        Request[8] = (byte)(Request[8] | 4);
                    }
                    if (this.flLeadsMode2) {
                        Request[8] = (byte)(Request[8] | 0x40);
                    }
                    Request[9] = 0;
                    if (this.flDisplayLightOn) {
                        Request[9] = (byte)(Request[9] | 1);
                    }
                    Request[10] = 0;
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0440\u0435\u0436\u0438\u043c\u0430 \u043f\u0440\u0438\u0431\u043e\u0440\u0430");
                    }
                    if (Response[2] != 4) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0440\u0435\u0436\u0438\u043c\u0430 \u043f\u0440\u0438\u0431\u043e\u0440\u0430");
                    }
                    this.Frequency = (Response[3] & 1) != 0 ? 2 : 1;
                    this.Channels = (Response[3] & 2) != 0 ? 2 : 1;
                    boolean bl = this.flReoChannel = (Response[3] & 4) != 0;
                    this.flLowPowerConsumption = (this.DeviceType == 1 && this.DeviceHWVersion >= 1 || this.DeviceType == 2 && this.DeviceHWVersion >= 2) && this.DeviceSWVersion >= 31 ? (Response[3] & 0x10) != 0 : false;
                    this.flMovementChannel = (Response[3] & 0x20) != 0;
                    boolean bl2 = this.flRecording = (Response[3] & 0x40) != 0;
                    this.flIVR = this.DeviceType == 1 || this.DeviceType == 2 && this.DeviceSWVersion >= 2 ? (Response[3] & 0x80) != 0 : false;
                    this.flDisplayOn = (Response[4] & 1) != 0;
                    this.flControllingFilter50Hz = (Response[4] & 2) == 0;
                    boolean bl3 = this.flUnreadStorage = (Response[4] & 4) == 0;
                    if ((Response[4] & 0x10) != 0) {
                        this.Leads = 3;
                    } else if ((Response[4] & 0x20) != 0) {
                        this.Leads = 4;
                    }
                    this.flLeadsMode2 = (Response[4] & 0x40) != 0;
                    boolean bl4 = this.flDisplayLightOn = (Response[5] & 1) != 0;
                    this.flBrokenLeadsControlIsSet = (this.DeviceType == 1 && this.DeviceHWVersion >= 1 || this.DeviceType == 2 && this.DeviceHWVersion >= 1) && this.DeviceSWVersion >= 31 ? (Response[5] & 4) != 0 : false;
                    this.DeviceHardwareStatus = (this.DeviceType == 1 && this.DeviceHWVersion >= 1 || this.DeviceType == 2 && this.DeviceHWVersion >= 1) && this.DeviceSWVersion >= 33 ? Response[6] : 0;
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        if (_E != null) {
            throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_SetMode(), " + _E.getLocalizedMessage(), _E);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int Device_InterfaceModule_GetData() throws Exception {
        int TryCount = 3;
        int NoReplyCount = 0;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[8];
                    for (int J = 0; J < Request.length; ++J) {
                        Request[J] = 13;
                    }
                    this.Device_Request_Send(Request);
                    try {
                        byte[] Response = new byte[4];
                        this.Connector.Read(Response, Response.length, 3000);
                        int n = TDataConverter.ConvertBEByteArrayToInt32(Response, 0);
                        return n;
                    }
                    catch (Exception E) {
                        ++NoReplyCount;
                        throw E;
                    }
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E2) {
                if (NoReplyCount == 3) {
                    return 0;
                }
                _E = E2;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_InterfaceModule_GetData(), " + _E.getLocalizedMessage(), _E);
    }

    public int Device_Port_Speed_Set(int Value) throws Exception {
        if (this.DeviceType == 1 || this.DeviceType == 2 && this.DeviceSWVersion >= 28) {
            byte[] Request = new byte[]{42, 31, 1, (byte)Value};
            this.Device_Request_Send(Request);
            byte[] Response = this.Device_Response_Receive(3000);
            if (Response[1] != Request[1]) {
                throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e\u0440\u0442\u0430");
            }
            if (Response[2] != 1) {
                throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e\u0440\u0442\u0430");
            }
            this.DevicePortSpeed = Value;
            return Response[3] & 0xFF;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Device_Port_Speed_Get() throws Exception {
        if (this.DeviceType != 1 && (this.DeviceType != 2 || this.DeviceSWVersion < 28)) {
            throw new Exception("Device_Port_Speed_Get() not supported in this version of firmware");
        }
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            int n;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 31, 1, -1};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e\u0440\u0442\u0430");
                }
                if (Response[2] != 1) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e\u0440\u0442\u0430");
                }
                n = Response[3] & 0xFF;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return n;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Port_Speed_Get(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Clock_SetTime(TDateTime Value) throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    int SS = Value.getSeconds();
                    int NN = Value.getMinutes();
                    int HH = Value.getHours();
                    int DD = Value.getDate();
                    int MM = Value.getMonth();
                    int YY = Value.getYear() - 2000;
                    byte[] Request = new byte[10];
                    Request[0] = 42;
                    Request[1] = 7;
                    Request[2] = 7;
                    Request[3] = (byte)(SS / 10 << 4 | SS % 10);
                    Request[4] = (byte)(NN / 10 << 4 | NN % 10);
                    Request[5] = (byte)(HH / 10 << 4 | HH % 10);
                    Request[7] = (byte)(DD / 10 << 4 | DD % 10);
                    Request[8] = (byte)(MM / 10 << 4 | MM % 10);
                    Request[9] = (byte)(YY / 10 << 4 | YY % 10);
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Clock_SetTime(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDateTime Device_Clock_GetTime() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            TDateTime tDateTime;
            this.Device_Connect();
            try {
                TDateTime Result2;
                byte[] Request = new byte[]{42, 8, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
                }
                if (Response[2] != 7) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
                }
                int SS = (Response[3] >>> 4) * 10 + (Response[3] & 0xF);
                int NN = (Response[4] >>> 4) * 10 + (Response[4] & 0xF);
                int HH = (Response[5] >>> 4) * 10 + (Response[5] & 0xF);
                int DD = (Response[7] >>> 4) * 10 + (Response[7] & 0xF);
                int MM = (Response[8] >>> 4) * 10 + (Response[8] & 0xF);
                int YY = (Response[9] >>> 4) * 10 + (Response[9] & 0xF) + 2000;
                tDateTime = Result2 = new TDateTime(YY, MM, DD, HH, NN, SS, 0);
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return tDateTime;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Clock_GetTime(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TBatteryState Device_Battery_GetState() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            TBatteryState tBatteryState;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 14, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u0439");
                }
                if (Response[2] != 2) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0431\u0430\u0442\u0430\u0440\u0435\u0439");
                }
                TBatteryState Result2 = new TBatteryState();
                Result2.Ubat1 = (double)Response[3] / 100.0;
                Result2.Ubat2 = (double)Response[4] / 100.0;
                tBatteryState = Result2;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return tBatteryState;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Battery_GetState(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Device_Display_SwitchLight(boolean flOn) throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            boolean bl;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 24, 1, (byte)(flOn ? 1 : 0)};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0438 \u044d\u043a\u0440\u0430\u043d\u0430");
                }
                if (Response[2] != 1) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0438 \u044d\u043a\u0440\u0430\u043d\u0430");
                }
                bl = Response[3] != 0;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return bl;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Display_SwitchLight(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Storage_Clear() throws Exception {
        if (this.flRecording) {
            this.Device_Storage_Recording_Stop();
        }
        int StorageCapacity = this.Device_Storage_GetCapacity();
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Response;
                    byte[] Request = new byte[]{42, 12, 0};
                    this.Device_Request_Send(Request);
                    int CommandReadTimeout = 10000;
                    while ((Response = this.Device_Response_Receive(10000))[2] != 2) {
                    }
                    if (this.DeviceType == 2 && this.DeviceSWVersion >= 31) {
                        int BadBlockCount;
                        short ErrorsCount = TDataConverter.ConvertBEByteArrayToInt16(Response, Response.length - 2);
                        TDEVICEModule.log.trace("Device_Storage_Clear(), storage clearing errors: " + ErrorsCount);
                        if (ErrorsCount > 0 && (BadBlockCount = this.Device_Storage_GetState()) > 0 && I == 2) {
                            throw new Exception("\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u043e\u0447\u0438\u0449\u0435\u043d, \u043d\u043e \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0431\u0438\u0442\u044b\u0435 \u0431\u043b\u043e\u043a\u0438, \u0447\u0438\u0441\u043b\u043e: " + Integer.toString(BadBlockCount));
                        }
                        if (Response[Response.length - 2] != 0 && Response[Response.length - 2] == 1 && I == 2) {
                            throw new Exception("\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u043e\u0447\u0438\u0449\u0435\u043d, \u043d\u043e \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u0438\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u043c\u044f\u0442\u0438, \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u044b\u0441\u043b\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u0432 \u0440\u0435\u043c\u043e\u043d\u0442");
                        }
                    } else if (Response[Response.length - 2] == 0 && Response[Response.length - 2] == 1 && I == 2) {
                        throw new Exception("\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u043e\u0447\u0438\u0449\u0435\u043d, \u043d\u043e \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u0438\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u043c\u044f\u0442\u0438, \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u044b\u0441\u043b\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u0432 \u0440\u0435\u043c\u043e\u043d\u0442");
                    }
                    this.flUnreadStorage = false;
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_Clear(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Device_Storage_GetType() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            int n;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 29, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0438\u043f\u0430 \u043f\u0430\u043c\u044f\u0442\u0438");
                }
                if (Response[2] != 5) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0438\u043f\u0430 \u043f\u0430\u043c\u044f\u0442\u0438");
                }
                n = TDataConverter.ConvertBEByteArrayToInt32(Response, 4);
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return n;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_GetType(), " + _E.getLocalizedMessage(), _E);
    }

    public int Device_Storage_GetCapacity() throws Exception {
        switch (this.DeviceStorageType) {
            case 218: {
                return 131072;
            }
            case 220: {
                return 262144;
            }
        }
        return 131072;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int Device_Storage_GetState() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[]{42, 25, 0};
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u0430\u043c\u044f\u0442\u0438");
                    }
                    if (Response[2] != 2) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u0430\u043c\u044f\u0442\u0438");
                    }
                    if (this.DeviceType == 1 || this.DeviceType == 2 && this.DeviceSWVersion >= 30) {
                        byte by = Response[4];
                        return by;
                    }
                    int n = Response[4] | Response[3] << 8;
                    return n;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                ++I;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_GetState(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Storage_ResetWatermark() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[]{42, 19, 5, 0, 0, 0, 0, 0};
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_ResetWatermark(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TStorageWatermark Device_Storage_GetWatermark() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            TStorageWatermark tStorageWatermark;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 15, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430");
                }
                if (Response[2] != 5) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430");
                }
                TStorageWatermark Result2 = new TStorageWatermark();
                Result2.Offset = (Response[3] & 0xFF | (Response[4] & 0xFF) << 8) & 0xFFF & 0xFFFF;
                Result2.BlockIndex = (Response[5] & 0xFF | (Response[6] & 0xFF) << 8 | (Response[7] & 0xFF) << 16) & 0xFFFFFF;
                tStorageWatermark = Result2;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return tStorageWatermark;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_GetWatermark(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Storage_Recording_Start() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[]{42, 9, 0};
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438");
                    }
                    if (Response[2] != 1) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438");
                    }
                    if ((Response[3] & 0x40) == 0) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438");
                    }
                    this.flRecording = true;
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_Recording_Start(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Storage_Recording_Stop() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[]{42, 10, 0};
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438");
                    }
                    if (Response[2] != 1) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438");
                    }
                    if ((Response[3] & 0x40) != 0) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438");
                    }
                    this.flRecording = false;
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_Recording_Stop(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Device_Storage_Recording_IsActive() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            boolean bl;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 4, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
                if (Response[2] != 1) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
                bl = (Response[3] & 0x40) != 0;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return bl;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_Recording_IsActive(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRecordingSize Device_Storage_Recording_GetSize() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            TRecordingSize tRecordingSize;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 20, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
                if (Response[2] != 5) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0437\u0430\u043f\u0440\u043e\u0441 \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
                TRecordingSize Result2 = new TRecordingSize();
                Result2.Offset = (Response[3] & 0xFF | (Response[4] & 0xFF) << 8) & 0xFFF & 0xFFFF;
                Result2.BlockCount = (Response[5] & 0xFF | (Response[6] & 0xFF) << 8 | (Response[7] & 0xFF) << 16) & 0xFFFFFF;
                tRecordingSize = Result2;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return tRecordingSize;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_GetRecordingSize(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDateTime Device_Storage_Recording_GetTimestamp() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            TDateTime tDateTime;
            this.Device_Connect();
            try {
                TDateTime Result2;
                byte[] Request = new byte[]{42, 18, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
                if (Response[2] != 7) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
                int SS = (Response[3] >>> 4) * 10 + (Response[3] & 0xF);
                int NN = (Response[4] >>> 4) * 10 + (Response[4] & 0xF);
                int HH = (Response[5] >>> 4) * 10 + (Response[5] & 0xF);
                int DD = (Response[7] >>> 4) * 10 + (Response[7] & 0xF);
                int MM = (Response[8] >>> 4) * 10 + (Response[8] & 0xF);
                int YY = (Response[9] >>> 4) * 10 + (Response[9] & 0xF) + 2000;
                tDateTime = Result2 = new TDateTime(YY, MM, DD, HH, NN, SS, 0);
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return tDateTime;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_GetRecordingTimestamp(), " + _E.getLocalizedMessage(), _E);
    }

    private void Device_Storage_Recording_DoReadBlocks(int Position, byte[][] Blocks) throws Exception {
        int Count = Blocks.length;
        byte[] Request = new byte[]{42, 11, 6, (byte)(Position & 0xFF), (byte)(Position >>> 8 & 0xFF), (byte)(Position >>> 16 & 0xFF), (byte)(Count & 0xFF), (byte)(Count >>> 8 & 0xFF), (byte)(Count >>> 16 & 0xFF)};
        System.out.println("COMMAND:  READ BLOCKS: " + Blocks.length);
        this.Connector.Reading_Purge();
        this.Device_Request_Send(Request);
        int CommandReadTimeout = 60000;
        int BlockReadTimeout = 1000;
        for (int I = 0; I < Count; ++I) {
            try {
                int Size = Blocks[I].length;
                int ActualSize = this.Connector.Read(Blocks[I], Size, I == 0 ? 60000 : 1000);
                if (ActualSize == Size) continue;
                System.out.println("MISSED SIZE: " + (Size - ActualSize));
                continue;
            }
            catch (Exception E) {
                System.out.println("EXCEPTION: " + E.toString() + ", iteration: " + I + ", in buffer: " + this.Connector.Reading_Avaiable());
                throw E;
            }
        }
        this.Connector.Normalize();
    }

    public void Device_Storage_Recording_ReadBlocks(int Position, byte[][] Blocks) throws Exception {
        int Reading_PortSpeed_Low = 4;
        if (Position == 0) {
            this.Device_Port_Speed_Set(0);
        }
        Object _E = null;
        while (true) {
            int TryCount = 3;
            for (int I = 0; I < 3; ++I) {
                try {
                    this.Device_Storage_Recording_DoReadBlocks(Position, Blocks);
                    Thread.sleep(110L);
                    return;
                }
                catch (IOException IOE) {
                    if (IOE.getCause() instanceof TimeoutException) {
                        Thread.sleep(110L);
                        TDEVICEModule.log.info("Device_Storage_Recording_ReadBlocks(), reading timeout");
                        continue;
                    }
                    throw IOE;
                }
                catch (TimeoutException TE) {
                    Thread.sleep(110L);
                    TDEVICEModule.log.info("Device_Storage_Recording_ReadBlocks(), reading timeout");
                }
            }
            if ((this.DeviceType != 2 || this.DeviceSWVersion < 28) && (this.DeviceType != 1 || this.DeviceSWVersion < 12) || 0 > this.DevicePortSpeed || this.DevicePortSpeed >= 4) break;
            this.Device_Port_Speed_Set(this.DevicePortSpeed + 1);
            TDEVICEModule.log.info("Device_Storage_Recording_ReadBlocks(), reading speed: " + this.DevicePortSpeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Storage_Recording_MarkAsRead() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[11];
                    Request[0] = 42;
                    Request[1] = 3;
                    Request[2] = 8;
                    Request[3] = 0;
                    Request[4] = 4;
                    Request[5] = 0;
                    Request[6] = 0;
                    Request[7] = 0;
                    Request[8] = 0;
                    Request[8] = (byte)(Request[8] | 4);
                    Request[9] = 0;
                    Request[10] = 0;
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u0430\u043a \u043f\u0440\u043e\u0447\u0442\u0451\u043d\u043d\u0430\u044f");
                    }
                    if (Response[2] != 4) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u0430\u043a \u043f\u0440\u043e\u0447\u0442\u0451\u043d\u043d\u0430\u044f");
                    }
                    boolean bl = this.flUnreadStorage = (Response[4] & 4) == 0;
                    if (this.flUnreadStorage) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u0430\u043a \u043f\u0440\u043e\u0447\u0442\u0451\u043d\u043d\u0430\u044f");
                    }
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Storage_Recording_MarkAsRead(), " + _E.getLocalizedMessage(), _E);
    }

    public void Device_Monitoring_Start() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                byte[] Request = new byte[]{42, 5, 0};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0441\u0442\u0430\u0440\u0442 \u0440\u0435\u0436\u0438\u043c\u0430 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430");
                }
                if ((Response[3] & 8) == 0) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0441\u0442\u0430\u0440\u0442 \u0440\u0435\u0436\u0438\u043c\u0430 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430");
                }
                return;
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Monitoring_Start(), " + _E.getLocalizedMessage(), _E);
    }

    public void Device_Monitoring_Stop() throws Exception {
        byte[] Request = new byte[]{42, 6, 0};
        int TryCount = 3;
        for (int I = 0; I < 3; ++I) {
            this.Device_Request_Send(Request);
        }
    }

    public void Device_Monitoring_ReadBuffer(byte[] Buffer, int Size) throws Exception {
        this.Connector.Read(Buffer, Size, 3000);
    }

    public void Device_Monitoring_Normalize() throws Exception {
        byte[] Request = new byte[]{42, 22, 0};
        int TryCount = 3;
        for (int I = 0; I < 3; ++I) {
            this.Device_Request_Send(Request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Device_Monitoring_Shunt_Set(boolean Value) throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            boolean bl;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 33, 1, (byte)(Value ? 1 : 0)};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0448\u0443\u043d\u0442\u0430");
                }
                if (Response[2] != 1) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0448\u0443\u043d\u0442\u0430");
                }
                bl = (Response[3] & 4) != 0;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return bl;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Monitoring_Shunt_Set(), " + _E.getLocalizedMessage(), _E);
    }

    public void Device_Monitoring_50HzFilter_Set(boolean Value) throws Exception {
        byte[] Request = new byte[]{42, 23, 1, Value ? (byte)3 : 0};
        int TryCount = 3;
        for (int I = 0; I < 3; ++I) {
            this.Device_Request_Send(Request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Device_SetBrokenLeadsControl(boolean Value) throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            boolean bl;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 33, 1, (byte)(Value ? 1 : 0)};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u043e\u0431\u0440\u044b\u0432\u043e\u0432");
                }
                if (Response[2] != 1) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u043e\u0431\u0440\u044b\u0432\u043e\u0432");
                }
                bl = (Response[3] & 4) != 0;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return bl;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_SetBrokenLeadsControl(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Device_Patient_SetInfo(TPatientInfo Value) throws Exception {
        int TryCount = 3;
        Exception _E = null;
        for (int I = 0; I < 3; ++I) {
            try {
                this.Device_Connect();
                try {
                    byte[] Request = new byte[162];
                    Request[0] = 42;
                    Request[1] = 1;
                    Request[2] = -97;
                    Request[3] = 0;
                    int Idx = 4;
                    System.arraycopy(Value.Name, 0, Request, Idx, Value.Name.length);
                    byte[] BA = TDataConverter.ConvertDoubleToBEByteArray(Value.BirthDate);
                    System.arraycopy(BA, 0, Request, Idx += 128, BA.length);
                    Request[Idx += BA.length] = Value.Gender;
                    Request[++Idx] = Value.Constitution;
                    BA = TDataConverter.ConvertInt32ToBEByteArray(Value.Diagnose);
                    System.arraycopy(BA, 0, Request, ++Idx, BA.length);
                    System.arraycopy(Value.GUID, 0, Request, Idx += BA.length, Value.GUID.length);
                    Idx += Value.GUID.length;
                    this.Device_Request_Send(Request);
                    byte[] Response = this.Device_Response_Receive(3000);
                    if (Response[1] != Request[1]) {
                        throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430");
                    }
                    return;
                }
                finally {
                    this.Device_Disconnect();
                }
            }
            catch (Exception E) {
                _E = E;
                continue;
            }
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Patient_SetInfo(), " + _E.getLocalizedMessage(), _E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPatientInfo Device_Patient_GetInfo() throws Exception {
        int TryCount = 3;
        Exception _E = null;
        int I = 0;
        while (I < 3) {
            TPatientInfo tPatientInfo;
            this.Device_Connect();
            try {
                byte[] Request = new byte[]{42, 2, 2, 0, -98};
                this.Device_Request_Send(Request);
                byte[] Response = this.Device_Response_Receive(3000);
                if (Response[1] != Request[1]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430");
                }
                if (Response[2] != Request[4]) {
                    throw new Exception("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430");
                }
                TPatientInfo Result2 = new TPatientInfo();
                int Idx = 3;
                Result2.Name = new byte[128];
                System.arraycopy(Response, Idx, Result2.Name, 0, Result2.Name.length);
                Result2.BirthDate = TDataConverter.ConvertBEByteArrayToDouble(Response, Idx += Result2.Name.length);
                Result2.Gender = Response[Idx += 8];
                Result2.Constitution = Response[++Idx];
                Result2.Diagnose = TDataConverter.ConvertBEByteArrayToInt32(Response, ++Idx);
                Result2.GUID = new byte[16];
                System.arraycopy(Response, Idx += 4, Result2.GUID, 0, Result2.GUID.length);
                if (Result2.BirthDate == Double.POSITIVE_INFINITY || Result2.BirthDate == Double.NEGATIVE_INFINITY || Result2.BirthDate != Double.NaN) {
                    Result2.BirthDate = 0.0;
                }
                tPatientInfo = Result2;
            }
            catch (Throwable throwable) {
                try {
                    this.Device_Disconnect();
                    throw throwable;
                }
                catch (Exception E) {
                    _E = E;
                    ++I;
                }
            }
            this.Device_Disconnect();
            return tPatientInfo;
        }
        throw new IOException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f Device_Patient_GetInfo(), " + _E.getLocalizedMessage(), _E);
    }

    public static class TPatientInfo {
        public byte[] Name;
        public double BirthDate;
        public byte Gender;
        public byte Constitution;
        public int Diagnose;
        public byte[] GUID;

        public void Name_Set(String Value) throws UnsupportedEncodingException {
            byte[] NameBA = Value.trim().getBytes("windows-1251");
            this.Name = new byte[128];
            int Length = NameBA.length;
            if (Length > this.Name.length) {
                Length = this.Name.length;
            }
            System.arraycopy(NameBA, 0, this.Name, 0, Length);
        }

        public String Name_Get() throws UnsupportedEncodingException {
            return new String(this.Name, "windows-1251").trim();
        }
    }

    public static class TRecordingSize {
        public int BlockCount;
        public int Offset;
    }

    public static class TStorageWatermark {
        public int BlockIndex;
        public int Offset;
    }

    public static class TBatteryState {
        public double Ubat1;
        public double Ubat2;
    }
}

