/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.Utils;

import com.esn.CGMServer.Utils.IAvailable;
import com.esn.CGMServer.Utils.ICleanable;
import com.esn.CGMServer.Utils.IDisable;
import com.esn.CGMServer.Utils.IFillable;
import com.esn.CGMServer.Utils.IMarkableInputStream;
import com.esn.CGMServer.Utils.IMarkableOutputStream;
import com.esn.CGMServer.Utils.IMarkableStream;
import com.esn.CGMServer.Utils.ITimeoutable;
import com.esn.CGMServer.Utils.TAutoResetEvent;
import com.esn.CGMServer.Utils.TCanceller;
import com.esn.CGMServer.Utils.TInOutStream;
import com.esn.CGMServer.Utils.TManualResetEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;

public class TMemoryInOutStreamAdapter
extends TInOutStream
implements ICleanable,
IDisable {
    private static final double Normalizing_Threshold = 1.048576E7;
    public TMyInputStream InStream;
    public TMyOutputStream OutStream;
    private boolean flReadExactly;
    private int Capacity;
    private byte[] Memory;
    protected int Size;
    protected long AbsoluteSize;
    private ArrayList<IMarkableStream.TMark> Marks = new ArrayList();
    private IMarkableStream.IMarksEventHandler Marks_EventHandler = null;
    protected int Position;
    protected long AbsolutePosition;
    public int Writing_Buffering_Limit = -1;
    public volatile int Writing_Timeout = -1;
    public volatile int Writing_Timeout_Counter = 0;
    private TManualResetEvent Writing_Signal = new TManualResetEvent(true);
    private volatile Exception Writing_Exception = null;
    public volatile int Reading_Timeout = -1;
    private TAutoResetEvent Reading_Signal = new TAutoResetEvent();
    private TManualResetEvent Reading_Data_Signal = new TManualResetEvent(false);
    private TManualResetEvent Reading_NoData_Signal = new TManualResetEvent(true);
    protected boolean flDisabled = false;
    public IFilter Filter = null;
    public TEventHandler EventHandler = null;
    protected Object DoWrite_Lock = new Object();
    protected long Write_Counter = 0L;

    public TMemoryInOutStreamAdapter(boolean pflReadExactly, int pCapacity) {
        this.flReadExactly = pflReadExactly;
        this.Capacity = pCapacity;
        this.Memory = new byte[this.Capacity];
        this.Size = 0;
        this.AbsoluteSize = 0L;
        this.Position = 0;
        this.AbsolutePosition = 0L;
        this.InStream = this.CreateInputStream();
        this.OutStream = this.CreateOutputStream();
    }

    public TMemoryInOutStreamAdapter(boolean pflReadExactly) {
        this(pflReadExactly, 8192);
    }

    public TMemoryInOutStreamAdapter(int pCapacity) {
        this(false, pCapacity);
    }

    public TMemoryInOutStreamAdapter() {
        this(false);
    }

    @Override
    public void Destroy(boolean flCancel) throws Exception {
        if (this.OutStream != null) {
            this.OutStream.close();
        }
        if (this.InStream != null) {
            this.InStream.close();
        }
        super.Destroy(flCancel);
        this.Writing_Signal.Set();
        this.Reading_Signal.Set();
        this.Reading_NoData_Signal.Set();
    }

    protected TMyInputStream CreateInputStream() {
        return new TMyInputStream();
    }

    protected TMyOutputStream CreateOutputStream() {
        return new TMyOutputStream();
    }

    @Override
    public TMyInputStream InStream() {
        return this.InStream;
    }

    @Override
    public TMyOutputStream OutStream() {
        return this.OutStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SetCapacity(int NewCapacity) {
        byte[] _Memory = new byte[NewCapacity];
        TMemoryInOutStreamAdapter tMemoryInOutStreamAdapter = this;
        synchronized (tMemoryInOutStreamAdapter) {
            if (this.Size > 0) {
                System.arraycopy(this.Memory, 0, _Memory, 0, this.Size);
            }
            this.Capacity = NewCapacity;
            this.Memory = _Memory;
        }
    }

    public synchronized void Normalize() {
        if ((double)this.Position > 1.048576E7) {
            int Delta = this.Size - this.Position;
            System.arraycopy(this.Memory, this.Position, this.Memory, 0, Delta);
            this.Position = 0;
            this.Size = Delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int DoWrite(byte[] Buffer, int BufferOffset, int BufferSize, IMarkableStream.TMark Mark) throws IOException {
        if (BufferSize == 0 || this.flDisabled || this.Filter != null && !this.Filter.Accept(this.Write_Counter, Buffer, BufferOffset, BufferSize, Mark)) {
            return 0;
        }
        long Timestamp = System.currentTimeMillis();
        Object object = this.DoWrite_Lock;
        synchronized (object) {
            try {
                if (this.Writing_Buffering_Limit >= 0) {
                    int Timeout;
                    if (this.Writing_Timeout < 0) {
                        Timeout = 1000;
                        while (!this.Writing_Signal.WaitOne(1000)) {
                            this.CheckExistance();
                        }
                    } else {
                        Timeout = (int)((long)this.Writing_Timeout - (System.currentTimeMillis() - Timestamp));
                        if (Timeout < 0) {
                            Timeout = 0;
                        }
                        if (!this.Writing_Signal.WaitOne(Timeout)) {
                            ++this.Writing_Timeout_Counter;
                            throw new TimeoutException();
                        }
                    }
                    this.CheckExistance();
                }
            }
            catch (InterruptedException IE) {
                throw new IOException(IE);
            }
            catch (Exception E) {
                throw new IOException(E);
            }
            TMemoryInOutStreamAdapter tMemoryInOutStreamAdapter = this;
            synchronized (tMemoryInOutStreamAdapter) {
                int _Reading_Available;
                while (this.Size + BufferSize > this.Capacity) {
                    this.SetCapacity(this.Capacity << 1);
                }
                System.arraycopy(Buffer, BufferOffset, this.Memory, this.Size, BufferSize);
                this.Size += BufferSize;
                this.AbsoluteSize += (long)BufferSize;
                this.DoWrite_SetMark(Mark);
                if (this.Writing_Buffering_Limit >= 0 && (_Reading_Available = this.Size - this.Position) > this.Writing_Buffering_Limit) {
                    this.Writing_Signal.Reset();
                }
                this.Reading_Data_Signal.Set();
                this.Reading_NoData_Signal.Reset();
            }
            ++this.Write_Counter;
            this.Reading_Signal.Set();
            return BufferSize;
        }
    }

    protected void DoWrite_SetMark(IMarkableStream.TMark Mark) {
        if (Mark != null) {
            this.Mark(Mark);
        }
    }

    public int Write(byte[] Buffer, int BufferOffset, int BufferSize, IMarkableStream.TMark Mark) throws IOException {
        int Result2 = this.DoWrite(Buffer, BufferOffset, BufferSize, Mark);
        ++this.Write_Counter;
        return Result2;
    }

    public int Write(byte[] Buffer, int BufferOffset, int BufferSize) throws IOException {
        return this.Write(Buffer, BufferOffset, BufferSize, null);
    }

    public int Writing_Available() {
        if (this.Writing_Signal.HasSignalled()) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public boolean Writing_WaitForAvailable(int Timeout) throws Exception {
        boolean Result2 = this.Writing_Signal.WaitOne(Timeout);
        if (!Result2) {
            ++this.Writing_Timeout_Counter;
        }
        this.CheckExistance();
        return Result2;
    }

    public void Writing_WaitForAvailable() throws Exception {
        int Timeout = 1000;
        while (!this.Writing_Signal.WaitOne(1000)) {
            this.CheckExistance();
        }
        this.CheckExistance();
    }

    public void Writing_Flush() {
    }

    public void Writing_Exception_Set(Exception E) {
        this.Writing_Exception = E;
        this.Reading_Signal.Set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void Writing_CleanFromMark(IMarkableStream.TMark Mark) throws IOException {
        long Delta = this.AbsoluteSize - Mark.AbsoluteSize;
        if (Delta <= 0L) {
            return;
        }
        this.Size = (int)((long)this.Size - Delta);
        this.AbsoluteSize -= Delta;
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            while (this.Marks.size() > 0) {
                int Idx = this.Marks.size() - 1;
                if (this.Marks.get((int)Idx).AbsoluteSize <= this.AbsoluteSize) break;
                this.Marks_RemoveOne(Idx, true);
            }
        }
        int _Reading_Available = this.Size - this.Position;
        if (_Reading_Available == 0) {
            this.Size = 0;
            this.Position = 0;
            this.Reading_Data_Signal.Reset();
            this.Reading_NoData_Signal.Set();
            if (this.EventHandler != null) {
                this.EventHandler.DoOnEmpty();
            }
        } else {
            this.Normalize();
        }
        if (this.Writing_Buffering_Limit >= 0 && _Reading_Available <= this.Writing_Buffering_Limit) {
            this.Writing_Signal.Set();
        }
    }

    public synchronized void Writing_CleanFromNextMark() throws IOException {
        IMarkableStream.TMark NextMark = this.Marks_GetNext();
        if (NextMark != null) {
            this.Writing_CleanFromMark(NextMark);
        }
    }

    /*
     * Exception decompiling
     */
    private int DoRead(byte[] Buffer, int BufferOffset, int BufferSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int DoReadExactly(byte[] Buffer, int BufferOffset, int BufferSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int Read(byte[] buffer, int offset, int length) throws IOException {
        if (this.EventHandler != null) {
            this.EventHandler.DoBeforeRead(length);
            int Result2 = this.flReadExactly ? this.DoReadExactly(buffer, offset, length) : this.DoRead(buffer, offset, length);
            this.EventHandler.DoAfterRead(buffer, offset, length);
            return Result2;
        }
        return this.flReadExactly ? this.DoReadExactly(buffer, offset, length) : this.DoRead(buffer, offset, length);
    }

    private synchronized int DoReadReversively(byte[] Buffer, int BufferOffset, int BufferSize, IMarkableStream.TMark Mark) throws IOException {
        int Delta = (int)(Mark.AbsolutePosition - this.AbsolutePosition);
        if (Delta < BufferSize) {
            throw new IOException("DoReadReversively(): BufferSize is too long");
        }
        Mark.AbsolutePosition -= (long)BufferSize;
        System.arraycopy(this.Memory, this.Position + (Delta -= BufferSize), Buffer, BufferOffset, BufferSize);
        if (Delta == 0) {
            Delta = (int)(Mark.AbsoluteSize - this.AbsolutePosition);
            this.Position += Delta;
            this.AbsolutePosition += (long)Delta;
            this.Reading_UpdateMarks(false);
            int _Reading_Available = this.Size - this.Position;
            if (_Reading_Available == 0) {
                this.Size = 0;
                this.Position = 0;
                this.Reading_Data_Signal.Reset();
                this.Reading_NoData_Signal.Set();
                if (this.EventHandler != null) {
                    this.EventHandler.DoOnEmpty();
                }
            } else {
                this.Normalize();
            }
            if (this.Writing_Buffering_Limit >= 0 && _Reading_Available <= this.Writing_Buffering_Limit) {
                this.Writing_Signal.Set();
            }
        }
        return BufferSize;
    }

    public int ReadReversively(byte[] buffer, int offset, int length, IMarkableStream.TMark Mark) throws IOException {
        if (this.EventHandler != null) {
            this.EventHandler.DoBeforeRead(length);
            int Result2 = this.DoReadReversively(buffer, offset, length, Mark);
            this.EventHandler.DoAfterRead(buffer, offset, length);
            return Result2;
        }
        return this.DoReadReversively(buffer, offset, length, Mark);
    }

    public synchronized int Reading_Available() {
        int Result2 = this.Size - this.Position;
        if (this.Writing_Buffering_Limit >= 0 && Result2 > this.Writing_Buffering_Limit) {
            Result2 = this.Writing_Buffering_Limit;
        }
        return Result2;
    }

    public synchronized int Reading_Available(IMarkableStream.TMark Mark) {
        int Result2 = (int)(Mark.AbsolutePosition - this.AbsolutePosition);
        if (Result2 <= 0) {
            try {
                throw new IOException("no data available");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.Writing_Buffering_Limit >= 0 && Result2 > this.Writing_Buffering_Limit) {
            Result2 = this.Writing_Buffering_Limit;
        }
        return Result2;
    }

    public boolean Reading_WaitForCompletion(int Timeout) throws Exception {
        boolean Result2 = this.Reading_NoData_Signal.WaitOne(Timeout);
        this.CheckExistance();
        return Result2;
    }

    public void Reading_WaitForCompletion() throws Exception {
        int Timeout = 1000;
        while (!this.Reading_NoData_Signal.WaitOne(1000)) {
            this.CheckExistance();
        }
        this.CheckExistance();
    }

    public synchronized void Reading_SkipToMark(IMarkableStream.TMark Mark) throws IOException {
        long Delta = Mark.AbsoluteSize - this.AbsolutePosition;
        if (Delta <= 0L) {
            return;
        }
        this.Position = (int)((long)this.Position + Delta);
        this.AbsolutePosition += Delta;
        this.Reading_UpdateMarks(true);
        int _Reading_Available = this.Size - this.Position;
        if (_Reading_Available == 0) {
            this.Size = 0;
            this.Position = 0;
            this.Reading_Data_Signal.Reset();
            this.Reading_NoData_Signal.Set();
            if (this.EventHandler != null) {
                this.EventHandler.DoOnEmpty();
            }
        } else {
            this.Normalize();
        }
        if (this.Writing_Buffering_Limit >= 0 && _Reading_Available <= this.Writing_Buffering_Limit) {
            this.Writing_Signal.Set();
        }
    }

    public synchronized void Reading_SkipToNextMark() throws IOException {
        IMarkableStream.TMark NextMark = this.Marks_GetNext();
        if (NextMark != null) {
            this.Reading_SkipToMark(NextMark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean Reading_UpdateMarks(boolean flSkipping) {
        boolean Result2 = false;
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            while (this.Marks.size() > 0 && this.AbsolutePosition >= this.Marks.get((int)0).AbsoluteSize) {
                this.Marks_RemoveOne(0, flSkipping);
                Result2 = true;
            }
        }
        return Result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Mark(IMarkableStream.TMark Mark) {
        Mark.AbsolutePosition = Mark.AbsoluteSize = this.AbsoluteSize;
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            this.Marks.add(Mark);
            if (this.Marks_EventHandler != null) {
                this.Marks_EventHandler.DoOnMarkAdded(Mark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Marks_Count() {
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            return this.Marks.size();
        }
    }

    public IMarkableStream.TMark Marks_RemoveOne(int Index, boolean flSkipping) {
        IMarkableStream.TMark Result2 = this.Marks.remove(Index);
        if (this.Marks_EventHandler != null) {
            this.Marks_EventHandler.DoOnMarkRemoved(Result2, flSkipping);
        }
        return Result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarkableStream.TMark Marks_GetNext() {
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            if (this.Marks.size() > 0) {
                return this.Marks.get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarkableStream.TMark Marks_GetLast() {
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            int Cnt = this.Marks.size();
            if (Cnt > 0) {
                return this.Marks.get(Cnt - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarkableStream.TMark Marks_CompactNext() {
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            if (this.Marks.size() > 0) {
                IMarkableStream.TMark Mark = this.Marks.get(0);
                while (this.Marks.size() > 1) {
                    IMarkableStream.TMark NextMark = this.Marks.get(1);
                    if (NextMark.Type != Mark.Type || !NextMark.Tag.equals(Mark.Tag) || NextMark.Flags != Mark.Flags) break;
                    Mark = NextMark;
                    this.Marks_RemoveOne(0, true);
                }
                return Mark;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarkableStream.TMark Marks_CompactNext(int Limit) {
        ArrayList<IMarkableStream.TMark> arrayList = this.Marks;
        synchronized (arrayList) {
            if (this.Marks.size() > 0) {
                IMarkableStream.TMark Mark = this.Marks.get(0);
                while (this.Marks.size() > 1) {
                    IMarkableStream.TMark NextMark = this.Marks.get(1);
                    if (NextMark.Type != Mark.Type || !NextMark.Tag.equals(Mark.Tag) || NextMark.Flags != Mark.Flags) break;
                    Mark = NextMark;
                    this.Marks_RemoveOne(0, true);
                    if (--Limit != 0) continue;
                }
                return Mark;
            }
            return null;
        }
    }

    @Override
    public synchronized void Clean(int Timeout, TCanceller Canceller) throws Exception {
        this.Size = 0;
        this.Position = 0;
        this.Reading_Data_Signal.Reset();
        this.Reading_NoData_Signal.Set();
        if (this.EventHandler != null) {
            this.EventHandler.DoOnEmpty();
        }
        if (this.Writing_Buffering_Limit >= 0) {
            this.Writing_Signal.Set();
        }
    }

    @Override
    public void Disable(int Timeout, TCanceller Canceller) throws Exception {
        this.flDisabled = true;
    }

    @Override
    public void Enable(int Timeout, TCanceller Canceller) throws Exception {
        this.flDisabled = false;
    }

    @Override
    public boolean IsDisabled(int Timeout, TCanceller Canceller) throws Exception {
        return this.flDisabled;
    }

    public class TMyOutputStream
    extends OutputStream
    implements ITimeoutable,
    IAvailable,
    ICleanable,
    IDisable,
    IFillable,
    IMarkableOutputStream,
    IMarkableStream.IMarksEventHandler.IAccessor {
        private IMarkableStream.TMark NextMark = null;

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (count > 0) {
                if (TMemoryInOutStreamAdapter.this.EventHandler != null) {
                    TMemoryInOutStreamAdapter.this.EventHandler.DoBeforeWrite(buffer, offset, count);
                    TMemoryInOutStreamAdapter.this.Write(buffer, offset, count, this.NextMark);
                    this.NextMark = null;
                    TMemoryInOutStreamAdapter.this.EventHandler.DoAfterWrite(buffer, offset, count);
                } else {
                    TMemoryInOutStreamAdapter.this.Write(buffer, offset, count);
                }
            }
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(int oneByte) throws IOException {
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            TMemoryInOutStreamAdapter.this.Writing_Flush();
        }

        @Override
        public void Timeout_Set(int Value) throws Exception {
            TMemoryInOutStreamAdapter.this.Writing_Timeout = Value;
        }

        @Override
        public int Timeout_Get() throws Exception {
            return TMemoryInOutStreamAdapter.this.Writing_Timeout;
        }

        @Override
        public int Available() {
            return TMemoryInOutStreamAdapter.this.Writing_Available();
        }

        @Override
        public void Clean(int Timeout, TCanceller Canceller) throws Exception {
            TMemoryInOutStreamAdapter.this.Clean(Timeout, Canceller);
        }

        @Override
        public void Disable(int Timeout, TCanceller Canceller) throws Exception {
            TMemoryInOutStreamAdapter.this.Disable(Timeout, Canceller);
        }

        @Override
        public void Enable(int Timeout, TCanceller Canceller) throws Exception {
            TMemoryInOutStreamAdapter.this.Enable(Timeout, Canceller);
        }

        @Override
        public boolean IsDisabled(int Timeout, TCanceller Canceller) throws Exception {
            return TMemoryInOutStreamAdapter.this.IsDisabled(Timeout, Canceller);
        }

        @Override
        public IFillable.TFillingParameters GetFillingParameters(IFillable.TFillingParameters Parameters2, int Timeout, TCanceller Canceller) throws Exception {
            Parameters2.FilledSize = TMemoryInOutStreamAdapter.this.Reading_Available();
            Parameters2.Size = TMemoryInOutStreamAdapter.this.Writing_Buffering_Limit;
            return Parameters2;
        }

        @Override
        public void Mark(IMarkableStream.TMark Mark) {
            this.NextMark = Mark;
        }

        @Override
        public void MarksEventHandler_Set(IMarkableStream.IMarksEventHandler MarksEventHandler) {
            TMemoryInOutStreamAdapter.this.Marks_EventHandler = MarksEventHandler;
        }

        @Override
        public IMarkableStream.IMarksEventHandler MarksEventHandler_Get() {
            return TMemoryInOutStreamAdapter.this.Marks_EventHandler;
        }
    }

    public class TMyInputStream
    extends InputStream
    implements ITimeoutable,
    IAvailable,
    ICleanable,
    IDisable,
    IMarkableInputStream {
        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            return TMemoryInOutStreamAdapter.this.Read(buffer, offset, length);
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public void Timeout_Set(int Value) throws Exception {
            TMemoryInOutStreamAdapter.this.Reading_Timeout = Value;
        }

        @Override
        public int Timeout_Get() throws Exception {
            return TMemoryInOutStreamAdapter.this.Reading_Timeout;
        }

        @Override
        public int Available() {
            return TMemoryInOutStreamAdapter.this.Reading_Available();
        }

        @Override
        public void Clean(int Timeout, TCanceller Canceller) throws Exception {
            TMemoryInOutStreamAdapter.this.Clean(Timeout, Canceller);
        }

        @Override
        public void Disable(int Timeout, TCanceller Canceller) throws Exception {
            TMemoryInOutStreamAdapter.this.Disable(Timeout, Canceller);
        }

        @Override
        public void Enable(int Timeout, TCanceller Canceller) throws Exception {
            TMemoryInOutStreamAdapter.this.Enable(Timeout, Canceller);
        }

        @Override
        public boolean IsDisabled(int Timeout, TCanceller Canceller) throws Exception {
            return TMemoryInOutStreamAdapter.this.IsDisabled(Timeout, Canceller);
        }

        @Override
        public int Mark_Available(int Timeout) throws Exception {
            if (Timeout < 0) {
                int _Timeout = 1000;
                while (!TMemoryInOutStreamAdapter.this.Reading_Data_Signal.WaitOne(1000)) {
                    TMemoryInOutStreamAdapter.this.CheckExistance();
                }
            } else if (!TMemoryInOutStreamAdapter.this.Reading_Data_Signal.WaitOne(Timeout)) {
                throw new TimeoutException();
            }
            TMemoryInOutStreamAdapter.this.CheckExistance();
            IMarkableStream.TMark Mark = TMemoryInOutStreamAdapter.this.Marks_GetNext();
            if (Mark != null) {
                return TMemoryInOutStreamAdapter.this.Reading_Available(Mark);
            }
            return TMemoryInOutStreamAdapter.this.Reading_Available();
        }
    }

    public static class TEventHandler {
        public void DoBeforeWrite(byte[] Buffer, int Offset, int Length) throws IOException {
        }

        public void DoAfterWrite(byte[] Buffer, int Offset, int Length) throws IOException {
        }

        public void DoBeforeRead(int Length) throws IOException {
        }

        public void DoAfterRead(byte[] Buffer, int Offset, int Length) throws IOException {
        }

        public void DoOnEmpty() throws IOException {
        }
    }

    public static interface IFilter {
        public boolean Accept(long var1, byte[] var3, int var4, int var5, IMarkableStream.TMark var6);
    }
}

