/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.usb;

import com.ftdichip.usb.BMRequestType;
import com.ftdichip.usb.EEndpointDirection;
import com.ftdichip.usb.UsbHostManager;
import com.ftdichip.usb.enumerated.ChipType;
import com.ftdichip.usb.enumerated.FlowControl;
import com.ftdichip.usb.enumerated.LineBreak;
import com.ftdichip.usb.enumerated.LineDatabit;
import com.ftdichip.usb.enumerated.LineParity;
import com.ftdichip.usb.enumerated.LineStopbit;
import java.util.Arrays;
import java.util.Collection;
import javax.usb.UsbDevice;
import javax.usb.UsbException;

public class FTDIUtility {
    public static final short VENDOR_ID = 1027;
    public static final Short[] PRODUCT_ID = new Short[]{(short)24577, (short)24592, (short)24593};
    public static final int DEFAULT_BAUD_RATE = 115200;
    public static final int MODEM_STATUS_HEADER_LENGTH = 2;
    public static final byte FTDI_USB_CONFIGURATION_WRITE = new BMRequestType(EEndpointDirection.HOST_TO_DEVICE, BMRequestType.EType.VENDOR, BMRequestType.ERecipient.DEVICE).getByteCode();
    public static final byte FTDI_USB_CONFIGURATION_READ = new BMRequestType(EEndpointDirection.DEVICE_TO_HOST, BMRequestType.EType.VENDOR, BMRequestType.ERecipient.DEVICE).getByteCode();
    public static final byte SIO_RESET_REQUEST = 0;
    public static final byte SIO_SET_MODEM_CTRL_REQUEST = 1;
    public static final byte SIO_SET_FLOW_CTRL_REQUEST = 2;
    public static final byte SIO_SET_BAUDRATE_REQUEST = 3;
    public static final byte SIO_SET_DATA_REQUEST = 4;
    public static final byte SIO_POLL_MODEM_STATUS_REQUEST = 5;
    public static final byte SIO_SET_LATENCY_TIMER_REQUEST = 9;
    public static final byte SIO_SET_DTR_MASK = 1;
    public static final byte SIO_SET_DTR_HIGH = 1;
    public static final byte SIO_SET_DTR_LOW = 0;
    public static final byte SIO_SET_RTS_MASK = 2;
    public static final byte SIO_SET_RTS_HIGH = 2;
    public static final byte SIO_SET_RTS_LOW = 0;

    public static Collection<UsbDevice> findFTDIDevices() throws UsbException {
        return UsbHostManager.getUsbDeviceList((short)1027, Arrays.asList(PRODUCT_ID));
    }

    public static void reset(UsbDevice usbDevice) throws UsbException {
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)0, (short)0, (short)0));
    }

    public static void setBaudRate(UsbDevice usbDevice, int requestedBaudRate) throws UsbException, UsbException, UsbException {
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)3, FTDIUtility.calculateBaudRate(requestedBaudRate), (short)0));
    }

    public static int setBaudRate_General(UsbDevice usbDevice, int requestedBaudRate) throws UsbException {
        short[] baudRateConverted = FTDIUtility.convertBaudrate(requestedBaudRate);
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)3, baudRateConverted[2], baudRateConverted[1]));
        return baudRateConverted[0];
    }

    public static void setDTR(UsbDevice usbDevice, boolean state) throws UsbException {
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)1, state ? (short)1 : 0, (short)0));
    }

    public static void setRTS(UsbDevice usbDevice, boolean state) throws UsbException {
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)1, state ? (short)2 : 0, (short)0));
    }

    public static void setDTRRTS(UsbDevice usbDevice, boolean dtrState, boolean rtsState) throws UsbException {
        int dtrValue = dtrState ? 1 : 0;
        int rtsValue = rtsState ? 2 : 0;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)1, (short)(dtrValue | rtsValue), (short)0));
    }

    public static void setFlowControl(UsbDevice usbDevice, FlowControl flowcontrol) throws UsbException {
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)2, flowcontrol.getBytecode(), (short)0));
    }

    public static void setLineProperty(UsbDevice usbDevice, LineDatabit bits, LineStopbit stopbits, LineParity parity) throws UsbException {
        FTDIUtility.setLineProperty(usbDevice, bits, stopbits, parity, LineBreak.BREAK_OFF);
    }

    public static void setLineProperty(UsbDevice usbDevice, LineDatabit bits, LineStopbit stopbits, LineParity parity, LineBreak breaktype) throws UsbException {
        short value = (short)bits.getBits();
        switch (parity) {
            case NONE: {
                break;
            }
            case ODD: {
                value = (short)(value | 0x100);
                break;
            }
            case EVEN: {
                value = (short)(value | 0x200);
                break;
            }
            case MARK: {
                value = (short)(value | 0x300);
                break;
            }
            case SPACE: {
                value = (short)(value | 0x400);
                break;
            }
            default: {
                throw new AssertionError((Object)parity.name());
            }
        }
        switch (stopbits) {
            case STOP_BIT_1: {
                break;
            }
            case STOP_BIT_15: {
                value = (short)(value | 0x800);
                break;
            }
            case STOP_BIT_2: {
                value = (short)(value | 0x800);
                break;
            }
            default: {
                throw new AssertionError((Object)stopbits.name());
            }
        }
        switch (breaktype) {
            case BREAK_OFF: {
                break;
            }
            case BREAK_ON: {
                value = (short)(value | 0x4000);
                break;
            }
            default: {
                throw new AssertionError((Object)breaktype.name());
            }
        }
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)4, value, (short)0));
    }

    public static void SetLatencyTimer(UsbDevice usbDevice, short Value) throws UsbException, UsbException, UsbException {
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)9, Value, (short)0));
    }

    private static short calculateBaudRate(int requestedBaudRate) {
        int divisor = 3000000 / requestedBaudRate;
        return (short)(divisor << 16 >> 16);
    }

    private static short[] convertBaudrate(int baudrate) {
        long encodedDivisor;
        int divisor = 24000000 / baudrate;
        int bestDivisor = 0;
        Integer bestBaud = 0;
        int bestBaudDiff = 0;
        int[] fracCode = new int[]{0, 3, 2, 4, 1, 5, 6, 7};
        for (int i = 0; i < 2; ++i) {
            int baudEstimate;
            int tryDivisor = divisor + i;
            if (tryDivisor <= 8) {
                tryDivisor = 8;
            }
            int baudDiff = (baudEstimate = (24000000 + tryDivisor / 2) / tryDivisor) < baudrate ? baudrate - baudEstimate : baudEstimate - baudrate;
            if (i != 0 && baudDiff >= bestBaudDiff) continue;
            bestDivisor = tryDivisor;
            bestBaud = baudEstimate;
            bestBaudDiff = baudDiff;
            if (baudDiff == 0) break;
        }
        if ((encodedDivisor = (long)(bestDivisor >> 3 | fracCode[bestDivisor & 7] << 14)) == 1L) {
            encodedDivisor = 0L;
        } else if (encodedDivisor == 16385L) {
            encodedDivisor = 1L;
        }
        Long value = encodedDivisor & 0xFFFFL;
        Long index = encodedDivisor >> 16 & 0xFFFFL;
        return new short[]{bestBaud.shortValue(), index.shortValue(), value.shortValue()};
    }

    public static void ftdi_set_baudrate(UsbDevice iUsbDevice, int baudrate) throws Exception {
        short value = 0;
        short index = 0;
        int actual_baudrate = FTDIUtility.ftdi_convert_baudrate(baudrate, value, index);
        if (actual_baudrate <= 0) {
            throw new Exception("Bogus baudrate <= 0.");
        }
        if (actual_baudrate * 2 < baudrate || (actual_baudrate < baudrate ? actual_baudrate * 21 < baudrate * 20 : baudrate * 21 < actual_baudrate * 20)) {
            throw new Exception("Unsupported baudrate. Note: bitbang baudrates are automatically multiplied by 4");
        }
        iUsbDevice.syncSubmit(iUsbDevice.createUsbControlIrp(FTDI_USB_CONFIGURATION_WRITE, (byte)3, value, index));
    }

    private static int ftdi_convert_baudrate(int baudrate, short value, short index) {
        int best_baud;
        long encoded_divisor = 0L;
        if (baudrate <= 0) {
            return -1;
        }
        int H_CLK = 120000000;
        int C_CLK = 48000000;
        ChipType type = ChipType.TYPE_2232H;
        switch (type) {
            case TYPE_2232H: 
            case TYPE_4232H: 
            case TYPE_232H: {
                if (baudrate * 10 > H_CLK / 16383) {
                    best_baud = FTDIUtility.ftdi_to_clkbits(baudrate, H_CLK, 10, encoded_divisor);
                    encoded_divisor |= 0x20000L;
                    break;
                }
                best_baud = FTDIUtility.ftdi_to_clkbits(baudrate, C_CLK, 16, encoded_divisor);
                break;
            }
            case TYPE_BM: 
            case TYPE_2232C: 
            case TYPE_R: {
                best_baud = FTDIUtility.ftdi_to_clkbits(baudrate, C_CLK, 16, encoded_divisor);
                break;
            }
            default: {
                best_baud = FTDIUtility.ftdi_to_clkbits_AM(baudrate, encoded_divisor);
            }
        }
        value = (short)(encoded_divisor & 0xFFFFL);
        System.out.println("debug ftdi_convert_baudrate encoded_divisor " + encoded_divisor + " value " + value);
        if (type.equals((Object)ChipType.TYPE_2232H) || type.equals((Object)ChipType.TYPE_4232H) || type.equals((Object)ChipType.TYPE_232H)) {
            index = (short)(encoded_divisor >> 8);
            index = (short)(index & 0xFF00);
        } else {
            index = (short)(encoded_divisor >> 16);
        }
        System.out.println("debug ftdi_convert_baudrate best_baud " + best_baud + " value " + value + " index " + index);
        return best_baud;
    }

    private static int ftdi_to_clkbits(int baudrate, int clk, int clk_div, long encoded_divisor) {
        int best_baud;
        byte[] frac_code = new byte[]{0, 3, 2, 4, 1, 5, 6, 7};
        if (baudrate >= clk / clk_div) {
            encoded_divisor = 0L;
            best_baud = clk / clk_div;
        } else if (baudrate >= clk / (clk_div + clk_div / 2)) {
            encoded_divisor = 1L;
            best_baud = clk / (clk_div + clk_div / 2);
        } else if (baudrate >= clk / (2 * clk_div)) {
            encoded_divisor = 2L;
            best_baud = clk / (2 * clk_div);
        } else {
            int divisor = clk * 16 / clk_div / baudrate;
            int best_divisor = (divisor & 1) == 1 ? divisor / 2 + 1 : divisor / 2;
            if (best_divisor > 131072) {
                best_divisor = 131071;
            }
            best_baud = ((best_baud = clk * 16 / clk_div / best_divisor) & 1) == 1 ? best_baud / 2 + 1 : (best_baud /= 2);
            encoded_divisor = best_divisor >> 3 | frac_code[best_divisor & 7] << 14;
        }
        return best_baud;
    }

    private static int ftdi_to_clkbits_AM(int baudrate, long encoded_divisor) {
        byte[] frac_code = new byte[]{0, 3, 2, 4, 1, 5, 6, 7};
        byte[] am_adjust_up = new byte[]{0, 0, 0, 1, 0, 3, 2, 1};
        byte[] am_adjust_dn = new byte[]{0, 0, 0, 1, 0, 1, 2, 3};
        int divisor = 24000000 / baudrate;
        divisor -= am_adjust_dn[divisor & 7];
        int best_divisor = 0;
        int best_baud = 0;
        int best_baud_diff = 0;
        for (int i = 0; i < 2; ++i) {
            int try_divisor = divisor + i;
            if (try_divisor <= 8) {
                try_divisor = 8;
            } else if (divisor < 16) {
                try_divisor = 16;
            } else if ((try_divisor += am_adjust_up[try_divisor & 7]) > 131064) {
                try_divisor = 131064;
            }
            int baud_estimate = (24000000 + try_divisor / 2) / try_divisor;
            int baud_diff = baud_estimate < baudrate ? baudrate - baud_estimate : baud_estimate - baudrate;
            if (i != 0 && baud_diff >= best_baud_diff) continue;
            best_divisor = try_divisor;
            best_baud = baud_estimate;
            best_baud_diff = baud_diff;
            if (baud_diff == 0) break;
        }
        if ((encoded_divisor = (long)(best_divisor >> 3 | frac_code[best_divisor & 7] << 14)) == 1L) {
            encoded_divisor = 0L;
        } else if (encoded_divisor == 16385L) {
            encoded_divisor = 1L;
        }
        return best_baud;
    }
}

