/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbControlIrp;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import javax.usb.util.DefaultUsbControlIrp;
import javax.usb.util.DefaultUsbIrp;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.Endpoint;
import org.usb4java.javax.Interface;
import org.usb4java.javax.IrpQueue;
import org.usb4java.javax.PipeListenerList;

public class Pipe
implements UsbPipe {
    private final Endpoint endpoint;
    private final PipeListenerList listeners = new PipeListenerList();
    private boolean opened;
    public final IrpQueue queue;

    Pipe(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.queue = new IrpQueue(this);
    }

    public AbstractDevice getDevice() {
        return this.endpoint.getUsbInterface().getUsbConfiguration().getUsbDevice();
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new UsbNotActiveException("Pipe is not active.");
        }
    }

    private void checkClaimed() {
        if (!this.endpoint.getUsbInterface().isClaimed()) {
            throw new UsbNotClaimedException("Interface is not claimed.");
        }
    }

    private void checkConnected() {
        this.getDevice().checkConnected();
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new UsbNotOpenException("Pipe is not open.");
        }
    }

    @Override
    public void open() throws UsbException {
        this.checkActive();
        this.checkClaimed();
        this.checkConnected();
        if (this.opened) {
            throw new UsbException("Pipe is already open");
        }
        this.opened = true;
    }

    @Override
    public void close() throws UsbException {
        this.checkActive();
        this.checkClaimed();
        this.checkConnected();
        if (!this.opened) {
            throw new UsbException("Pipe is already closed");
        }
        if (this.queue.isBusy()) {
            throw new UsbException("Pipe is still busy");
        }
        this.opened = false;
    }

    @Override
    public boolean isActive() {
        Interface iface = this.endpoint.getUsbInterface();
        UsbConfiguration config = iface.getUsbConfiguration();
        return iface.isActive() && config.isActive();
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public Endpoint getUsbEndpoint() {
        return this.endpoint;
    }

    @Override
    public int syncSubmit(byte[] data) throws UsbException {
        UsbIrp irp = this.asyncSubmit(data);
        irp.waitUntilComplete();
        if (irp.isUsbException()) {
            throw irp.getUsbException();
        }
        return irp.getActualLength();
    }

    @Override
    public UsbIrp asyncSubmit(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        UsbIrp irp = this.createUsbIrp();
        irp.setAcceptShortPacket(true);
        irp.setData(data);
        this.asyncSubmit(irp);
        return irp;
    }

    @Override
    public void syncSubmit(UsbIrp irp) throws UsbException {
        if (irp == null) {
            throw new IllegalArgumentException("irp must not be null");
        }
        this.asyncSubmit(irp);
        irp.waitUntilComplete();
        if (irp.isUsbException()) {
            throw irp.getUsbException();
        }
    }

    @Override
    public void asyncSubmit(UsbIrp irp) {
        if (irp == null) {
            throw new IllegalArgumentException("irp must not be null");
        }
        this.checkActive();
        this.checkConnected();
        this.checkOpen();
        this.queue.add(irp);
    }

    @Override
    public void syncSubmit(List list) throws UsbException {
        for (Object item : list) {
            UsbIrp irp = (UsbIrp)item;
            this.syncSubmit(irp);
        }
    }

    @Override
    public void asyncSubmit(List list) {
        for (Object item : list) {
            UsbIrp irp = (UsbIrp)item;
            this.asyncSubmit(irp);
        }
    }

    @Override
    public void abortAllSubmissions() {
        this.checkActive();
        this.checkConnected();
        this.checkOpen();
        this.queue.abort();
    }

    @Override
    public UsbIrp createUsbIrp() {
        return new DefaultUsbIrp();
    }

    @Override
    public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new DefaultUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
    }

    @Override
    public void addUsbPipeListener(UsbPipeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUsbPipeListener(UsbPipeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Pipe GetPipe() {
        return this;
    }

    public void sendEvent(UsbIrp irp) {
        if (irp.isUsbException()) {
            this.listeners.errorEventOccurred(new UsbPipeErrorEvent((UsbPipe)this, irp));
        } else {
            this.listeners.dataEventOccurred(new UsbPipeDataEvent(this, irp));
        }
    }

    public String toString() {
        return String.format("USB pipe of endpoint %02x", this.endpoint.getUsbEndpointDescriptor().bEndpointAddress());
    }
}

