/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothRFCommConnection;
import java.io.IOException;
import java.io.OutputStream;

class BluetoothRFCommOutputStream
extends OutputStream {
    private volatile BluetoothRFCommConnection conn;

    public BluetoothRFCommOutputStream(BluetoothRFCommConnection conn) {
        this.conn = conn;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.conn == null) {
            throw new IOException("Stream closed");
        }
        this.conn.bluetoothStack.connectionRfWrite(this.conn.handle, b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.conn == null) {
            throw new IOException("Stream closed");
        }
        this.conn.bluetoothStack.connectionRfWrite(this.conn.handle, b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.conn == null) {
            throw new IOException("Stream closed");
        }
        super.flush();
        this.conn.bluetoothStack.connectionRfFlush(this.conn.handle);
    }

    @Override
    public void close() throws IOException {
        BluetoothRFCommConnection c = this.conn;
        if (c != null) {
            this.conn = null;
            c.streamClosed();
        }
    }

    boolean isClosed() {
        return this.conn == null;
    }
}

